/*
	Zadatak: Derbi
	---------------------------------------------------
	Prvi dio zadatka je otrkiti koje skupine pravokutnika ine spojene povrine,
	ovo je mogue izraunati obinim pretraivanjem u dubinu gdje su vorovi pravokutnici a veze meu njima postoje
	ako se preklapaju barem u jednoj toci. Za ovo izraunati potrebno je O(N^2) vremena.

	Drugi dio je izraunati povrine ovih skupina pravokutnika. Povrine moemo efikasno (O(N^2) - mogue je i bre) 
	izraunati pomou algoritma prebrisavanja ravnine. Jednom petljom prebrisujem ravninu horizontalno
	a drugom vertikalno.

	Dobar opis ovog algoritma (i problema koje rjeava) moete vidjeti ovdje: http://community.topcoder.com/tc?module=Static&d1=tutorials&d2=lineSweep
*/
#include <cstdio>
#include <vector>
#include <algorithm>
#include <queue>
#include <list>
using namespace std;

#define pb(x) push_back(x)

struct Rect{ int X1, Y1, X2, Y2; };
struct Event
{
	int Coord, rIndex;
	bool Open;
	Event(int c, int ri, int o) { Coord = c; rIndex = ri, Open = o; }

	friend bool operator < (const struct Event& a, const struct Event& b)
	{
		return (a.Coord < b.Coord);
	}
};

int N;
vector <Rect> r;
int g[1000][1000] =  { 0 };
int group[1000] = { 0 };

bool Overlap(int a, int b) { return (r[a].X1 <= r[b].X2 && r[a].X2 >= r[b].X1 && r[a].Y1 <= r[b].Y2 && r[a].Y2 >= r[b].Y1); }

void FloodFill(int x)
{
	for (int i = 0; i < N; ++i)
		if (g[x][i] && !group[i])
		{
			group[i] = group[x];
			FloodFill(i);
		}
}

int FindConnectedComponents()
{
	// Build graph
	for (int i = 0; i < N; ++i)
		for (int j = 0; j < N; ++j)
			g[i][j] = g[j][i] = Overlap(i, j);

	// Find groups
	int groupInd = 1;
	for (int i = 0; i < N; ++i)
		if (!group[i])
		{
			group[i] = groupInd++;
			FloodFill(i);
		}
	
	return groupInd - 1;
}

long long Union(int groupInd)
{
	// Preparation
	vector<bool> active(N, false);
	vector<Event> vert, horz;
	for (int i = 0; i < N; ++i)
		if (group[i] == groupInd)
		{
			vert.pb(Event(r[i].Y1, i, true));
			vert.pb(Event(r[i].Y2, i, false));
			horz.pb(Event(r[i].X1, i, true));
			horz.pb(Event(r[i].X2, i, false));
		}
	sort(vert.begin(), vert.end());
	sort(horz.begin(), horz.end());


	// Line sweep
	long long area = 0;
	int hInd = 0;

	while (horz[hInd].Coord == horz[0].Coord) 
		active[horz[hInd++].rIndex] = true;

	for (int i = 1; i < horz.size(); ++i) // Horizontal line sweep
	{
		int dX = horz[i].Coord - horz[i-1].Coord;
		if (dX == 0) 
		{ 
			active[horz[i].rIndex] = horz[i].Open; 
			continue;
		}

		int lastY;
		int count = 0;
		for (int j = 0; j < vert.size(); ++j) // Vertical line sweep
		{
			if (active[vert[j].rIndex])
			{ 
				if(vert[j].Open)
				{
					if (count == 0) 
						lastY = vert[j].Coord;
					count++;
				}
				else
				{
					count--;
					if (count == 0)
					{
						int dY = vert[j].Coord - lastY;
						area += (long long)dX * dY;
					}
				}
			}
		}
		active[horz[i].rIndex] = horz[i].Open;
	}

	return area;
}

int main()
{
	scanf("%d", &N);
	r.resize(N);
	for (int i = 0; i < N; ++i)
		scanf("%d %d %d %d", &r[i].X1, &r[i].Y1, &r[i].X2, &r[i].Y2);

	int nGroups = FindConnectedComponents();

	long long maxArea = 0;
	for (int i = 1; i <= nGroups; ++i)
		maxArea = max(maxArea, Union(i));

	printf("%lld\n", maxArea);	

	return 0;
}